function deletar(msg,url){
	swal({
		title: 'Ateno!!',
		text: 'Tem certeza que deseja excluir '+ msg +'?',
		type: 'warning',
		showCancelButton: true,
		confirmButtonColor: '#DD6B55',
		confirmButtonText: 'SIM',
		cancelButtonText: 'No',
		closeOnConfirm: false
	}, function(){
		document.location.href = url;
	});
}

function buscarCidades(){
	var estado = $('#estado').val();
	$.ajax({
		type: 'GET',  
		url: 'buscar_cidades.php?est='+ estado,
		success: function(dados) {
			$('#select2-chosen-2').html('---- selecione a cidade ----');
			$('#cidade').html(dados);
		}
	});
}

function buscarBairros(){
	var cidade = $('#cidade').val();
	$.ajax({
		type: 'GET',  
		url: 'buscar_bairros.php?cid='+ cidade,
		success: function(dados) {
			$('#select2-chosen-3').html('---- selecione o bairro ----');
			$('#bairro').html(dados);
		}
	});
}

function home_prevista(codigo){
	var url='index3_modal.php?acao=form&cod='+ codigo;
	
	$.ajax({url: url, success: function(result){
		$('.bs-example-modal-sm').html(result);
		$('.bs-example-modal-sm').modal('show');
		
		jQuery('#datepicker').datepicker();
	}});
}

function salvar_home_prevista(){
	var cod  = $('#cod').val();
	var data = $('#datepicker').val();
	
	var url='cad_turmas_alunos_modal.php?acao=salvar&cod='+ cod +'&data='+ data;
	
	$.ajax({url: url, success: function(result){
		$('.bs-example-modal-sm').modal('hide');
		
		$('#A_'+ cod).css('color','#e3a600');
		$('#DIV_prev_'+ cod).css('color','#e3a600');
		
		data_nov = data.substr(0,5);
		$('#DIV_prev_'+ cod).html(data_nov);
		
		swal('','Data salva com Sucesso!','success');
	}});
}

function data_prevista(codigo){
	var url='cad_turmas_alunos_modal.php?acao=form&cod='+ codigo;
	
	$.ajax({url: url, success: function(result){
		$('.bs-example-modal-sm').html(result);
		$('.bs-example-modal-sm').modal('show');
		
		jQuery('#datepicker').datepicker();
	}});
}

function salvar_prevista(){
	var cod  = $('#cod').val();
	var data = $('#datepicker').val();
	
	var url='cad_turmas_alunos_modal.php?acao=salvar&cod='+ cod +'&data='+ data;
	
	$.ajax({url: url, success: function(result){
		$('.bs-example-modal-sm').modal('hide');
		
		$('#TD_devendo_'+ cod).addClass('TD_previsto');
		
		swal('','Data salva com Sucesso!','success');
	}});
}


function mudarAno(curso){
	var url='cad_cursos_campos.php?camp=ano&curso='+ curso;
	
	$.ajax({url: url, success: function(result){
		$('#DIV_ano').html(result);
		$('#mes')    .val('');
		$('#turma')  .val('');
	}});
}

function mudarMes(ano){
	var curso = $('#curso').val();
	var url   = 'cad_cursos_campos.php?camp=mes&curso='+ curso +'&ano='+ ano;
	
	$.ajax({url: url, success: function(result){
		$('#DIV_mes').html(result);
		$('#turma')  .val('');
	}});
}

function mudarTurma(mes){
	var ano   = $('#ano').val();
	var curso = $('#curso').val();
	var url   = 'cad_cursos_campos.php?camp=turma&ano='+ ano +'&curso='+ curso +'&mes='+ mes;
	
	$.ajax({url: url, success: function(result){
		$('#DIV_turma').html(result);
	}});
}

function mudarValor(cod){
	var url='cad_cursos_campos.php?camp=valor&cod='+cod;
	
	$.ajax({url: url, success: function(result){
		$('#DIV_valor').html(result);
		calcular();
	}});
}

function atualizaValor(cod){
	var s_ponto = cod    .replace(".","");
	var nv_vlr  = s_ponto.replace(",",".");
	$('#vlr_curso_bruto').val( nv_vlr );
	
	calcular();
}

function atualizaEntrada(cod){
	var s_ponto = cod    .replace(".","");
	var nv_vlr  = s_ponto.replace(",",".");
	$('#vlr_entrada_bruto').val( nv_vlr );
	
	calcular();
}

function calcular(){
	var valor     = $('#vlr_curso_bruto').val();
	var entrada   = $('#vlr_entrada_bruto').val();
	var form_pagt = $('#form_pagto').val();
	var parc_cart = $('#qt_parc_cart').val();
	var parc_outr = $('#qt_parc_outr').val();
	var subtotal  = 0;
	var calculo   = 0;
	
	subtotal = valor - entrada;
	
	if(valor != '' && parc_outr != '' && form_pagt != '2'){
		calculo = eval(subtotal / parc_outr);
	}
	if(valor != '' && parc_cart != '' && form_pagt == '2'){
		//calculo = eval(subtotal / parc_cart);
		calculo = subtotal;
	}
	
	if(calculo > 0){
		$('#vlr_parcela').val( numeroParaMoeda(calculo) );
	}
	else{
		$('#vlr_parcela').val('');
	}
}

function numeroParaMoeda(n, c, d, t)
{
	c = isNaN(c = Math.abs(c)) ? 2 : c, d = d == undefined ? ',' : d, t = t == undefined ? '.' : t, s = n < 0 ? '-' : '', i = parseInt(n = Math.abs(+n || 0).toFixed(c)) + '', j = (j = i.length) > 3 ? j % 3 : 0;
	return s + (j ? i.substr(0, j) + t : '') + i.substr(j).replace(/(\d{3})(?=\d)/g, '$1' + t) + (c ? d + Math.abs(n - i).toFixed(c).slice(2) : '');
}

function mudarMensal(){
	verif = document.getElementById('mensal').checked;
	if(verif == true){
		document.getElementById('DIV_parcelas').style.display='none';
	}
	else{
		document.getElementById('DIV_parcelas').style.display='block';
	}
}

function mudarDocumento(cod){
	if(cod == '2'){
		document.getElementById('DIV_cpf') .style.display='none';
		document.getElementById('DIV_cnpj').style.display='block';
		$('#LABEL_nome') .html('Empresa');
		$('#LABEL_aluno').html('Nome do Aluno');
	}
	else{
		document.getElementById('DIV_cnpj').style.display='none';
		document.getElementById('DIV_cpf') .style.display='block';
		$('#LABEL_nome') .html('Nome');
		$('#LABEL_aluno').html('Aluno / Menor de Idade');
	}
	
	calcular();
}

function mudarQuantParc(cod){
	if(cod == '2'){
		document.getElementById('DIV_parcelas').       style.display='none';
		document.getElementById('DIV_parcelas_cartao').style.display='block';
	}
	else{
		document.getElementById('DIV_parcelas_cartao').style.display='none';
		document.getElementById('DIV_parcelas').       style.display='block';
	}
	
	calcular();
}

function mudarQuantParcVendas(cod){
	if(cod == '2'){
		document.getElementById('DIV_parcelas').style.display='block';
	}
	else{
		document.getElementById('DIV_parcelas').style.display='none';
	}
}

function mostrar_equip_locacao(num){
	num = parseFloat(num);
	
	for(x = 2 ; x <= 15 ; x++){
		if(num >= x){
			document.getElementById('DIV_equip_'+x).style.display='block';
		}else{
			document.getElementById('equipamento_'+x).value='';
			document.getElementById('DIV_equip_'+x).style.display='none';
		}
	}
	
	calcular_locacao();
}

function traz_valor_diaria(cod,num){
	var url='cad_equipamentos_locacao_campos.php?camp=vlr_diaria&cod='+ cod +'&num='+ num;
	
	$.ajax({url: url, success: function(result){
		$('#DIV_valor_diaria_'+ num).html(result);
		calcular_locacao();
	}});
}

function atualizaVlrDesconto(vlr){
	var s_ponto = vlr    .replace(".","");
	var nv_vlr  = s_ponto.replace(",",".");
	$('#vlr_desconto_bruto').val( nv_vlr );
	
	nv_vlr = parseFloat(nv_vlr);
	verif  = parseFloat($('#vlr_soma_bruto').val());
	if(verif < nv_vlr){
		swal('','O Desconto nao pode ser maior que a Soma!','error');
	}
	
	calcular_locacao();
}

function calcular_locacao(){
	var diarias = 0;
	var soma    = 0;
	var descont = 0;
	var total   = 0;
	
	for(x = 1 ; x <= 15 ; x++){
		if($('#equipamento_'+ x).val() != ""){
			diarias += eval($('#valor_diaria_'+ x).val());
		}
	}
	
	$('#vlr_diarias_bruto').val( diarias );
	$('#vlr_diarias').val( numeroParaMoeda(diarias) );
	
	quant = $('#qt_diarias').val();
	if(quant != ""){
		soma = eval(quant * diarias);
		
		$('#vlr_soma_bruto').val( soma );
		$('#vlr_soma').val( numeroParaMoeda(soma) );
		
		descont = $('#vlr_desconto_bruto').val();
		if(descont != ""){
			total = eval(soma - descont);
		}
		else{
			total = soma;
		}
		
		$('#vlr_total_bruto').val( total );
		$('#vlr_total').val( numeroParaMoeda(total) );
	}
	else{
		$('#vlr_soma').val("");
		$('#vlr_soma_bruto').val("");
		$('#vlr_total').val("");
		$('#vlr_total_bruto').val("");
	}
}

function mostrar_periodos(cod){
	if(cod == '3'){
		document.getElementById('dia_semana').value='';
		document.getElementById('datepicker-multiple').value='';
		document.getElementById('datepicker').value='';
		document.getElementById('hora_ini').value='';
		document.getElementById('hora_fim').value='';
		
		document.getElementById('DIV_dia_semana').style.display='none';
		document.getElementById('DIV_periodo').style.display='none';
		document.getElementById('DIV_horarios').style.display='none';
	}
	else{
		document.getElementById('DIV_dia_semana').style.display='block';
		document.getElementById('DIV_periodo').style.display='block';
		document.getElementById('DIV_horarios').style.display='block';
	}
	
	
	if(cod == '4'){
		document.getElementById('valor').value='';
		document.getElementById('DIV_valor').style.display='none';
	}
	else{
		document.getElementById('DIV_valor').style.display='block';
	}	
}

function mostrar_equip_vendas(num){
	num = parseFloat(num);
	
	for(x = 2 ; x <= 15 ; x++){
		if(num >= x){
			document.getElementById('DIV_equip_'+x).style.display='block';
			document.getElementById('DIV_num_serie_'+x).style.display='block';
			document.getElementById('DIV_vlr_venda_'+x).style.display='block';
			document.getElementById('DIV_vlr_custo_'+x).style.display='block';
			document.getElementById('DIV_espaco_'+x).style.display='block';
		}else{
			document.getElementById('equipamento_'+x).value='';
			document.getElementById('num_serie_'+x).value='';
			document.getElementById('vlr_venda_'+x).value='';
			document.getElementById('vlr_custo_'+x).value='';
			document.getElementById('vlr_venda_'+x+'_bruto').value='0';
			document.getElementById('vlr_custo_'+x+'_bruto').value='0';
			
			document.getElementById('DIV_equip_'+x).style.display='none';
			document.getElementById('DIV_num_serie_'+x).style.display='none';
			document.getElementById('DIV_vlr_venda_'+x).style.display='none';
			document.getElementById('DIV_vlr_custo_'+x).style.display='none';
			document.getElementById('DIV_espaco_'+x).style.display='none';
		}
	}
	
	calcular_vendas();
}

function mostr_valores_vendas(cod,num){
	var url='cad_equipamentos_vendas_campos.php?camp=vlr_venda&cod='+ cod +'&num='+ num;
	
	$.ajax({url: url, success: function(result){
		$('#DIV_vlr_venda_'+ num).html(result);
		calcular_vendas();
	}});
	
	var url='cad_equipamentos_vendas_campos.php?camp=vlr_custo&cod='+ cod +'&num='+ num;
	
	$.ajax({url: url, success: function(result){
		$('#DIV_vlr_custo_'+ num).html(result);
		calcular_vendas();
	}});
}

function atualizaVlrVenda(vlr,num){
	var s_ponto = vlr    .replace(".","");
	var nv_vlr  = s_ponto.replace(",",".");
	$('#vlr_venda_'+ num +'_bruto').val( nv_vlr );
	
	nv_vlr = parseFloat(nv_vlr);
	verif  = parseFloat($('#vlr_custo_'+ num +'_bruto').val());
	if(verif > nv_vlr){
		swal('','O Valor de Venda nao pode ser menor que o Valor de Custo!','error');
	}
	
	calcular_vendas();
}

function atualizaVlrCusto(vlr,num){
	var s_ponto = vlr    .replace(".","");
	var nv_vlr  = s_ponto.replace(",",".");
	$('#vlr_custo_'+ num +'_bruto').val( nv_vlr );
	
	nv_vlr = parseFloat(nv_vlr);
	verif  = parseFloat($('#vlr_venda_'+ num +'_bruto').val());
	if(verif < nv_vlr){
		swal('','O Valor de Custo nao pode ser maior que o Valor de Venda!','error');
	}
	
	calcular_vendas();
}

function calcular_vendas(){
	var total = 0;
	var custo = 0;
	var lucro = 0;
	
	for(x = 1 ; x <= 15 ; x++){
		if($('#equipamento_'+ x).val() != ""){
			total += eval($('#vlr_venda_'+ x +'_bruto').val());
			custo += eval($('#vlr_custo_'+ x +'_bruto').val());
		}
	}
	
	lucro = eval(total - custo);
	
	$('#vlr_total_bruto').val( total );
	$('#vlr_custo_bruto').val( custo );
	$('#vlr_lucro_bruto').val( lucro );
	
	$('#vlr_total').val( numeroParaMoeda(total) );
	$('#vlr_custo').val( numeroParaMoeda(custo) );
	$('#vlr_lucro').val( numeroParaMoeda(lucro) );
	
}

$('#email').focusout(function(){
	//atribuindo o valor do campo
	var sEmail	= $('#email').val();
	
	if(sEmail != ''){
		// filtros
		var emailFilter=/^.+@.+\..{2,}$/;
		var illegalChars= /[\(\)\<\>\,\;\:\\\/\"\[\]]/
		
		// condiao
		if(!(emailFilter.test(sEmail))||sEmail.match(illegalChars)){
			swal('','Informe um e-mail vlido!','error');
		}
	}
});

$('#cpf').focusout(function(){
	//atribuindo o valor do campo
	var strCPF	= $('#cpf').val();
	Result = "";
	
	if(strCPF != ''){
		
		var Soma;
		var Resto;
		var Result;
		Soma = 0;
		
		strCPF = strCPF.replace(".","");
		strCPF = strCPF.replace(".","");
		strCPF = strCPF.replace("-","");
		
		if (strCPF=="00000000000" || strCPF=="11111111111" || strCPF=="22222222222" || strCPF=="33333333333" || strCPF=="44444444444" || strCPF=="55555555555" || strCPF=="66666666666" || strCPF=="77777777777" || strCPF=="88888888888" || strCPF=="99999999999"){ Result = "erro"; }
		 
		for (i=1; i<=9; i++) Soma = Soma + parseInt(strCPF.substring(i-1, i)) * (11 - i);
		Resto = (Soma * 10) % 11;
		
		if ((Resto == 10) || (Resto == 11))  Resto = 0;
		if (Resto != parseInt(strCPF.substring(9, 10)) ){ Result = "erro"; }
		
		Soma = 0;
		for (i = 1; i <= 10; i++) Soma = Soma + parseInt(strCPF.substring(i-1, i)) * (12 - i);
		Resto = (Soma * 10) % 11;
		
		if ((Resto == 10) || (Resto == 11))  Resto = 0;
		if (Resto != parseInt(strCPF.substring(10, 11) ) ){ Result = "erro"; }
		
		if(Result == "erro"){
			swal('','Informe um CPF vlido!','error');
		}
	}
});

$('#cnpj').focusout(function(){
	//atribuindo o valor do campo
	var cnpj = $('#cnpj').val();
	Result = "";
	
	if(cnpj != ''){
		
		cnpj = cnpj.replace(".","");
		cnpj = cnpj.replace(".","");
		cnpj = cnpj.replace("/","");
		cnpj = cnpj.replace("-","");
		
		cnpj = cnpj.replace(/[^\d]+/g,'');
		 
		if (cnpj.length != 14)
			Result = "erro";
		
		if (cnpj == "00000000000000" || 
			cnpj == "11111111111111" || 
			cnpj == "22222222222222" || 
			cnpj == "33333333333333" || 
			cnpj == "44444444444444" || 
			cnpj == "55555555555555" || 
			cnpj == "66666666666666" || 
			cnpj == "77777777777777" || 
			cnpj == "88888888888888" || 
			cnpj == "99999999999999")
			Result = "erro";
		
		tamanho = cnpj.length - 2
		numeros = cnpj.substring(0,tamanho);
		digitos = cnpj.substring(tamanho);
		soma = 0;
		pos = tamanho - 7;
		for (i = tamanho; i >= 1; i--) {
		  soma += numeros.charAt(tamanho - i) * pos--;
		  if (pos < 2)
				pos = 9;
		}
		resultado = soma % 11 < 2 ? 0 : 11 - soma % 11;
		if (resultado != digitos.charAt(0))
			Result = "erro";
			 
		tamanho = tamanho + 1;
		numeros = cnpj.substring(0,tamanho);
		soma = 0;
		pos = tamanho - 7;
		for (i = tamanho; i >= 1; i--) {
		  soma += numeros.charAt(tamanho - i) * pos--;
		  if (pos < 2)
				pos = 9;
		}
		resultado = soma % 11 < 2 ? 0 : 11 - soma % 11;
		if (resultado != digitos.charAt(1))
			  Result = "erro";
			   
		if(Result == "erro"){
			swal('','Informe um CNPJ vlido!','error');
		}
	}
});

jQuery('.select2').select2({
	width: '370px',
	height: '28px'
});